unit IWCompLabel32;
{PUBDIST}

interface

uses
  {$IFDEF VSNET}
System.ComponentModel, System.Drawing,
  {$ELSE}
  {$IFDEF Linux}QControls, {$ELSE}Controls, {$ENDIF}
  {$ENDIF}
  {$IFDEF Linux}QGraphics, {$ELSE}Graphics, {$ENDIF}
  Classes,
  IWControl32, IWHTMLTag, IWRenderContext, IWMarkupLanguageTag;

type
  TIWCustomLabel32 = class(TIWCustomControl32)
  protected
    FRawText: Boolean;
    //

    {$IFDEF VSNET}
    function getText: string; reintroduce;virtual;
    procedure setText(AValue: string); reintroduce;virtual;
    {$ENDIF}
    procedure SetAutoSize(Value: Boolean); override;
    procedure InitControl; override;
  public
    function RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag; override;

    property RawText: Boolean read FRawText write FRawText default FALSE;
    {$IFNDEF CLR}
    property WebFont;
    {$ENDIF}
    {$IFDEF VSNET}
    property Text: string read getText write setText;
    {$ENDIF}
  published
    {$IFDEF CLR}
    property WebFont;
    {$ELSE}
    property Font;
    {$ENDIF}
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWLabel32.bmp}
  TIWLabel32 = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWLabel32), 'TIWLabel32.bmp')]
  {$ENDIF}
  TIWLabel32 = class(TIWCustomLabel32)
  published
    {$IFDEF VSNET}
    property Text;
    {$ELSE}
    property Caption;
    {$ENDIF}
    property RawText;
  end;

implementation

uses
  {$IFDEF VSNET}
  IWNetBaseControl,
  {$ENDIF}
  SysUtils;

{$IFDEF VSNET}
function TIWCustomLabel32.getText: string;
begin
  Result := Caption;
end;

procedure TIWCustomLabel32.setText(AValue: string); 
begin
  Caption := AValue;
  TIWNETBaseControl(Self).Invalidate;
end;
{$ENDIF}

function TIWCustomLabel32.RenderHTML(AContext: TIWBaseHTMLComponentContext): TIWHTMLTag;
begin
  //Fix this to allow CreateText
  Result := TIWHTMLTag.Create(TIWMarkupLanguageElement(nil));
  try
     if not RawText then
     begin
        Result.Contents.AddTagAsObject(WebFont.FontToStringTag32(TextToHTML(Caption)));
     end
     else
     begin
        Result.Contents.AddText(Caption);
     end;
  except
     FreeAndNil(Result);
     raise;
  end;
end;

procedure TIWCustomLabel32.InitControl;
begin
  inherited;
  Height := 21;
  Width := 121;
  AutoSize := true;
  FRawText := FALSE;
end;

procedure TIWCustomLabel32.SetAutoSize(Value: Boolean);
begin
  inherited SetAutoSize(Value);
  Invalidate;
end;

end.

